#!/bin/bash

TSV="$1"
PREFIX="$2"
DIR="$3"

function usage() {
    cat <<__EOT__
Usage: $(basename $0) [TSV] [PREFIX] [DIR]

Arguments:
  TSV		a tsv format dataset file
  PREFIX	a dataset prefix name (e.g. train, dev, test)
  DIR       the output directory for storing column files (e.g. name, smiles, inchi)
__EOT__
    exit -1
}

if [[ $# -ne 3 ]] || ! [[ -f $TSV ]] || ! [[ -d $DIR ]]; then
    usage
fi

cat $TSV | \
    sed -e '1d' | \
    awk -F '\t' \
		-v dir=$DIR -v prefix=$PREFIX \
		'{
		   print $1 > dir "/" prefix ".cid"
		   print $2 > dir "/" prefix ".name"
		   print $3 > dir "/" prefix ".smiles"
		   print $4 > dir "/" prefix ".inchi"
		   print $5 > dir "/" prefix ".type"
      	 }'
